unit recorder;

interface

uses
  Windows, Messages, SysUtils,  Classes, Graphics, Controls, Forms,
  Dialogs, mmSystem, ExtCtrls, StdCtrls, ComCtrls,
  Buttons, Menus, XPMan;

type

  EMyMCIException = class(Exception);
  TWavHeader = record       //needed to extract the wave file characteristics
    Marker1: array[0..3] of Char;
    BytesFollowing: Longint;
    Marker2: array[0..3] of Char;
    Marker3: array[0..3] of Char;
    Fixed1: Longint;
    FormatTag: Word;
    Channels: Word;
    SampleRate: Longint;
    BytesPerSecond: Longint;
    BytesPerSample: Word;
    BitsPerSample: Word;
    Marker4: array[0..3] of Char;
    DataBytes: Longint;
  end;


  TWaveRec = class(TForm)
    Timer1: TTimer;
    SaveDialog1: TSaveDialog;
    Button10: TButton;
    OpenDialog1: TOpenDialog;
    GroupBox1: TGroupBox;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Edit3: TEdit;
    Button15: TButton;
    CheckBox1: TCheckBox;
    StatusBar1: TStatusBar;
    Button17: TButton;
    MainMenu1: TMainMenu;
    Quit1: TMenuItem;
    Quit2: TMenuItem;
    About1: TMenuItem;
    About2: TMenuItem;
    Button16: TButton;
    Button18: TButton;
    Button19: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Button3: TButton;
    Button4: TButton;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Button9: TButton;
    ProgressBar1: TProgressBar;
    Button5: TButton;
    Button6: TButton;
    Edit2: TEdit;
    Button7: TButton;
    Button8: TButton;
    Label4: TLabel;
    Label2: TLabel;
    Label14: TLabel;
    Panel1: TPanel;
    TabSheet3: TTabSheet;
    Button20: TButton;
    Help1: TMenuItem;
    Help2: TMenuItem;
    Label8: TLabel;
    XPManifest1: TXPManifest;
    Label1: TLabel;
    VoiceKeyer1: TMenuItem;
    PlayMsg11: TMenuItem;
    PllayMsg21: TMenuItem;
    PlayMsg31: TMenuItem;
    PlayMsg41: TMenuItem;
    Stop1: TMenuItem;
    Number1: TMenuItem;
    Label3: TLabel;
   
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button18EndDock(Sender, Target: TObject; X, Y: Integer);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure About2Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure Quit2Click(Sender: TObject);
    procedure PlayMsg11Click(Sender: TObject);
    procedure PllayMsg21Click(Sender: TObject);
    procedure PlayMsg31Click(Sender: TObject);
    procedure PlayMsg41Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure Number1Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }

  end;

var
  WaveRec: TWaveRec;

implementation

{$R *.dfm}
uses WinTypes, ShellAPI;



procedure OpenObject( sObjectPath : string );
begin
  ShellExecute( 0, Nil, PChar( sObjectPath ),
                 Nil, Nil, SW_NORMAL );
end;


// Start Recording

procedure TWaveRec.Button1Click(Sender: TObject);
begin
   button3.visible:=false; //show Save buttons
   button4.visible:=false;
   Label2.Caption:='0';  //Sets label2 to 0
   Timer1.Enabled:=true; //Turns timer1 on for graphically showing recording length
   StatusBar1.Panels[1].text:='Recording started';
   Progressbar1.position:=0;  //reset
     
   mciSendString('OPEN NEW TYPE WAVEAUDIO ALIAS MicSound', nil, 0, Handle);

   mciSendString('SET MicSound TIME FORMAT MS ' +      // set the time format

        'BITSPERSAMPLE 8 ' +                            // 8 Bit
        'CHANNELS 1 ' +                                 // MONO
        'SAMPLESPERSEC 8000 ' +                         // 8 KHz
        'BYTESPERSEC 8000',                             // 8000 Bytes/s
        nil, 0, Handle);

  mciSendString('RECORD MicSound', nil, 0, Handle);
end;


// Stop Recording
procedure TWaveRec.Button2Click(Sender: TObject);
begin
  Timer1.Enabled:=false;   //Stops the timer
    
  mciSendString('STOP MicSound', nil, 0, Handle);
 // trackbar1.position:=0;
  button3.visible:=true; //show Save
  button4.visible:=true; //Show Save AS
  StatusBar1.Panels[1].text:='Recording concluded';
end;


// Save Wave File of what was just recorded
procedure TWaveRec.Button3Click(Sender: TObject);
begin
  mciSendString(PChar('SAVE MicSound ' +'recWaves\' +trim(Edit1.text)+ '.wav'), nil, 0, Handle);
  mciSendString('CLOSE MicSound', nil, 0, Handle);

  StatusBar1.Panels[1].text:= 'Wave file saved to : '+edit1.text+ '.wav'; //Lets you know its saved
    
  button3.visible:=false; //hide the Save buttons
  button4.visible:=false;
end;


procedure TWaveRec.Timer1Timer(Sender: TObject);
Var
s1 : integer;      //interval is set to 1000 (1 sec)
begin
  s1:=strtoint(label2.caption);          //Sets s1 to what ever label2 is
  label2.Caption:= inttostr(s1 + 1);     //Adds one to s1
  progressbar1.position:=s1+1;
end;

procedure TWaveRec.Button4Click(Sender: TObject);
begin    // Save As button
 if SaveDialog1.Execute then
    mciSendString(PChar('SAVE MicSound ' + SaveDialog1.filename), nil, 0, Handle);

 mciSendString('CLOSE MicSound', nil, 0, Handle);

 StatusBar1.Panels[1].text:= 'Wave file saved to ' + SaveDialog1.filename; //Lets you know its saved
 button3.visible:=false; //hide Save
 button4.visible:=false;
 end;


procedure TWaveRec.Button5Click(Sender: TObject);
var
wfile:string;
begin     // Play button
  Label1.Caption:='Playing';
  StatusBar1.Panels[1].text:='Playing';
  wfile:='recWaves\'+trim(edit2.text);
  if copy(wfile,length(wfile)-4,1) = '.' then
    begin
      wfile:=wfile+'.wav';
      PlaySound((PChar(wfile)), 0, SND_aSYNC); //play the sound asyncronously
      StatusBar1.Panels[1].text:='Finished Playing.';
    end
 else
   begin
     PlaySound((PChar(wfile)), 0, SND_aSYNC);
     StatusBar1.Panels[1].text:='Finished Playing.';
   end;

end;

procedure TWaveRec.Button6Click(Sender: TObject);
begin
  PlaySound(nil, 0, 0); // stop the current sound
  //  PlaySound(nil, 0, NULL); // stop the current sound    needs 0 instead of Null because no variants in D5 without defining
  Label1.Caption:='Finished';
  StatusBar1.Panels[1].text:='Finished';
end;

procedure TWaveRec.Button10Click(Sender: TObject);
begin   // loads the Windows audio panel
  WinExec('rundll32.exe shell32.dll,Control_RunDLL mmsys.cpl,,2',SW_SHOWNORMAL);
end;

procedure TWaveRec.Button9Click(Sender: TObject);
var   // allows deleting a previously recorded wave file
  fileName : string;
begin
  filename:=edit1.text+'.wav';
  if DeleteFile(Pchar(filename))then
    begin
      StatusBar1.Panels[1].text:= fileName+' deleted OK'//ShowMessage(fileName+' deleted OK')
    end
  else
    begin
      StatusBar1.Panels[1].text:=  fileName+' not deleted';//ShowMessage(fileName+' not deleted');
    end;
end;

procedure TWaveRec.Button7Click(Sender: TObject);
 var    //Finds existing wave files
  openDialog : TOpenDialog;    // Open dialog variable
  Header: TWavHeader;
  teststring:string;
begin
  // Set up the starting directory to be the current one
  teststring:=getcurrentdir;
  openDialog1.InitialDir := GetCurrentDir + '\recWaves\';

  // Only allow existing files to be selected
  openDialog1.Options := [ofFileMustExist];

  // Allow only .dpr and .pas files to be selected
  openDialog1.Filter :=
    'wave files|*.wav; //|Delphi pascal files|*.pas';

  // Select wav files as the starting filter type
  openDialog1.FilterIndex := 1;

  // Display the open file dialog
  if openDialog1.Execute
 /// then edit2.text:= openDialog.FilesName
  then
    begin
      edit2.text:= openDialog1.Filename;
      edit2.text:= trim(extractfilename(edit2.text));

      with TFileStream.Create(openDialog1.Filename, fmOpenRead) do
        try
          ReadBuffer(Header, SizeOf(Header));
        finally
          Free;
    end;
    // show the characteristics of the selected wave file
    Label1.Caption:= (FloatToStr((Int64(1000) * header.DataBytes div header.BytesPerSecond) / 1000))+' sec.';
    StatusBar1.Panels[1].text:= (FloatToStr((Int64(1000) * header.DataBytes div header.BytesPerSecond) / 1000))+' sec.';
   end
    //
  else
    // Free the dialog
    openDialog1.Free;
  button5.Visible:=true;  //Show the Play button
  button6.Visible:=true;  //Show the Stop button
  button5.SetFocus;  //focus on the Play button

end;


procedure TWaveRec.Button11Click(Sender: TObject);
var    //play the msg1.wave file you recorded
wfile:string;
begin
  wfile:='recWaves\' +'msg1.wav'; //trim(edit2.text);
  if copy(wfile,length(wfile)-4,1) = '.' then
    begin
      wfile:=wfile+'.wav';
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end
  else
    begin
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end;
end;

procedure TWaveRec.Button14Click(Sender: TObject);
var   //play the  ordinal number wave files you recorded (these are in the
      //defaultWaves folder
i:integer;
wfile,wfile2,wfile3,wfile4:string;
begin

  edit3.text:= inttostr(strtoint(edit3.text)+1);  //increment the counter
  if checkbox1.checked=true then
    begin   //add leading zeros if necessary
      if length(edit3.text)<3 then edit3.text:='0'+edit3.text;
      if length(edit3.text)<3 then edit3.text:='0'+edit3.text;
    end;
  i := length(trim(edit3.text)) ;
  case i of //if there are no leading zeros, handle it this way for single digits
    1:  begin
          case  strtoint(copy(trim(edit3.text),1,1)) of
            0..9:wfile:= 'defaultWaves\' +copy(trim(edit3.text),1,1)+'.wav';
          end; //case
          PlaySound((PChar(wfile)), 0, SND_SYNC);
          StatusBar1.Panels[1].text:='Finished Playing.';
        end;

    2:  begin //if there are no leading zeros, handle it this way for double digits
          case  strtoint(copy(trim(edit3.text),1,1)) of
            0..9:wfile:='defaultWaves\' + copy(trim(edit3.text),1,1)+'.wav';
          end; //case

          PlaySound((PChar(wfile)), 0, SND_SYNC);

          case  strtoint(copy(trim(edit3.text),2,1)) of
            0..9:wfile2:= 'defaultWaves\' +copy(trim(edit3.text),2,1)+'.wav';
          end; //case
          PlaySound((PChar(wfile2)), 0, SND_SYNC);
          StatusBar1.Panels[1].text:='Finished Playing.';

        end;

    3:  begin //if there are no leading zeros, handle it this way for triple digits
          case  strtoint(copy(trim(edit3.text),1,1)) of
            0..9:wfile:= 'defaultWaves\' +copy(trim(edit3.text),1,1)+'.wav';
            end; //case
          PlaySound((PChar(wfile)), 0, SND_SYNC);

          case  strtoint(copy(trim(edit3.text),2,1)) of
            0..9:wfile2:= 'defaultWaves\' +copy(trim(edit3.text),2,1)+'.wav';
            end; //case
          PlaySound((PChar(wfile2)), 0, SND_SYNC);

          case  strtoint(copy(trim(edit3.text),3,1)) of
            0..9:wfile2:= 'defaultWaves\' +copy(trim(edit3.text),3,1)+'.wav';
            end; //case
          PlaySound((PChar(wfile2)), 0, SND_SYNC);
          StatusBar1.Panels[1].text:='Finished Playing.';
         end;

     4:  begin
          case  strtoint(copy(trim(edit3.text),1,1)) of
            0..9:wfile:= 'defaultWaves\' +copy(trim(edit3.text),1,1)+'.wav';
          end; //case
          PlaySound((PChar(wfile)), 0, SND_SYNC);

          case  strtoint(copy(trim(edit3.text),2,1)) of
            0..9:wfile2:= 'defaultWaves\' +copy(trim(edit3.text),2,1)+'.wav';
          end; //case
          PlaySound((PChar(wfile2)), 0, SND_SYNC);

          case  strtoint(copy(trim(edit3.text),3,1)) of
            0..9:wfile2:= 'defaultWaves\' +copy(trim(edit3.text),3,1)+'.wav';
          end; //case
          PlaySound((PChar(wfile2)), 0, SND_SYNC);

          case  strtoint(copy(trim(edit3.text),4,1)) of
            0..9:wfile2:= 'defaultWaves\' +copy(trim(edit3.text),4,1)+'.wav';
          end; //case
          PlaySound((PChar(wfile2)), 0, SND_SYNC);
          StatusBar1.Panels[1].text:='Finished Playing.';
        end;
    end; 
end;

procedure TWaveRec.Button15Click(Sender: TObject);
var
backup,dummy:string;
number:integer;
begin   //reset the contact number counter
  number:=strtoint(edit3.text);
  if number<>0 then
    number:=number-1;
  edit3.text:=inttostr(number);
  if checkbox1.checked=true then
    begin
      if length(edit3.text)<3 then edit3.text:='0'+edit3.text;
      if length(edit3.text)<3 then edit3.text:='0'+edit3.text;
    end;
end;

procedure TWaveRec.Button8Click(Sender: TObject);
var
wfile:string;
begin
  PlaySound(nil, 0, 0); // stop the current sound
  //  PlaySound(nil, 0, NULL); // stop the current sound    needs 0 instead of Null because no variants in D5 without defining
  Label1.Caption:='Finished';
  StatusBar1.Panels[1].text:='Finished';

  wfile:='recWaves\'+trim(edit2.text);
  PlaySound((PChar(wfile)), 0, SND_ASYNC);
  StatusBar1.Panels[1].text:='Finished Playing.';
end;

procedure TWaveRec.Button12Click(Sender: TObject);
var
wfile:string;
begin
  wfile:='recWaves\' +'msg2.wav'; //trim(edit2.text);
  if copy(wfile,length(wfile)-4,1) = '.' then
    begin
      wfile:=wfile+'.wav';
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end
  else
    begin
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end;
end;

procedure TWaveRec.Button13Click(Sender: TObject);
var //send the msg3.wave message
wfile:string;
begin
  wfile:='recWaves\' +'msg3.wav'; //trim(edit2.text);
  if copy(wfile,length(wfile)-4,1) = '.' then
    begin
      wfile:=wfile+'.wav';
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end
  else
    begin
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end;
end;

procedure TWaveRec.Button17Click(Sender: TObject);
var  //send the msg4.wave message
wfile:string;
begin
  wfile:='recWaves\' +'msg4.wav';
  if copy(wfile,length(wfile)-4,1) = '.' then
    begin
      wfile:=wfile+'.wav';
      PlaySound((PChar(wfile)), 0, SND_SYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end
  else
    begin
      PlaySound((PChar(wfile)), 0, SND_aSYNC);
      StatusBar1.Panels[1].text:='Finished Playing.';
    end;
end;

procedure TWaveRec.Button18EndDock(Sender, Target: TObject; X, Y: Integer);
begin
  button18.visible:=true; 
end;

procedure TWaveRec.Button18Click(Sender: TObject);
begin      //coordinates for groupbox1
  groupbox1.ManualDock(WaveRec,WaveRec,alnone);
  GroupBox1.visible:=true;
  GroupBox1.left:=8;
  GroupBox1.top:= 207;
end;

procedure TWaveRec.Button19Click(Sender: TObject);
begin  //stop a voice keyer message
  PlaySound(nil, 0, 0); // stop the current sound
  //  PlaySound(nil, 0, NULL); // stop the current sound    needs 0 instead of Null because no variants in D5 without defining
   StatusBar1.Panels[1].text:='Finished';
end;

procedure TWaveRec.About2Click(Sender: TObject);
begin
  MessageDlg('WB5KIA Recorder  Audio Keyer'+#10#13+'  Copyright 2007 WB5KIA'+#10#13+#10#13+ '   A simple voice keyer',mtInformation,        [mbOK], 0);
end;

procedure TWaveRec.Button20Click(Sender: TObject);
var
  Win98Plus, Win2K, WinXP, WinVista: Boolean;

begin //show proper version of Windows Sound Recorder
  Win98Plus := (Win32MajorVersion > 4) or
    ((Win32MajorVersion = 4) and (Win32MinorVersion > 0));
  Win2K := (Win32MajorVersion > 4) and
    (Win32Platform = VER_PLATFORM_WIN32_NT);
  WinXP := CheckWin32Version(5, 1);
  WinVista := CheckWin32Version(6, 0);

  if win98Plus=true then OpenObject('sndrec32.exe')
  else if win2K=true then OpenObject('sndrec32.exe')
  else if winXp=true then OpenObject('sndrec32.exe')

  else if WinVista=true then OpenObject('SoundRecorder.exe');
  //however the Vista version only records, it does not
  //edit *.wav files as does sndrec32.

end;


procedure TWaveRec.Help2Click(Sender: TObject);
begin
  MessageDlg('A Help message could go here.',mtInformation, [mbOK], 0);
end;

procedure TWaveRec.Number1Click(Sender: TObject);
begin
  Button14.click;
end;

procedure TWaveRec.PlayMsg11Click(Sender: TObject);
begin
  Button11.click; 
end;

procedure TWaveRec.PlayMsg31Click(Sender: TObject);
begin
Button13.click;
end;

procedure TWaveRec.PlayMsg41Click(Sender: TObject);
begin
  Button17.click;
end;

procedure TWaveRec.PllayMsg21Click(Sender: TObject);
begin
  Button12.click;
end;

procedure TWaveRec.Quit2Click(Sender: TObject);
begin
  Close;
end;

procedure TWaveRec.Stop1Click(Sender: TObject);
begin
  Button19.click;
end;

end.
